const Sim800L = require('./GSM/Sim800L');
var app = require('express')();
var server = require('http').Server(app);
var io = require('socket.io')(server);
server.listen(107);
var sim800List = {};
var remoteSerialList = [];

app.get('/', function (req, res) {
    res.sendFile(__dirname + '/index.html');
});

io.on('connection', function (socket) {
    socket.emit('who', "");
    socket.on('iam', function (deviceName) {
        if (deviceName.match(/^Gardevoir/)) {
            console.log('sim', deviceName);
            if (!sim800List[deviceName]) {
                sim800List[deviceName] = new Sim800L({ name: deviceName });
            }
            sim800List[deviceName].attach(socket);
            sim800List[deviceName].askAccoutInfo();
            remoteSerialList.forEach(rm => {
                if (rm.sim800 != sim800List[deviceName]) {
                    rm.sim800 = sim800List[deviceName];
                    rm.listenDevice();
                }
            })
        }
        else {
            if (deviceName.match(/^RemoteSerial/)) {
                console.log('client', deviceName);
                var user = {
                    socket: socket

                };
                var simName = Object.keys(sim800List)[0];
                if (simName) {
                    user.sim800 = sim800List[simName];
                }

                user.onReadRx = function (data) {
                    user.socket.emit(':readRX', data);
                };

                user.onWriteTx = function (data) {
                    user.socket.emit(':writeTX', data);
                };

                user.listenDevice = function () {
                    if (user.sim800) {
                        user.socket.emit('listen', user.sim800.name);
                        user.sim800.on(':readRX', user.onReadRx);
                        user.sim800.on(':writeTX', user.onWriteTx);
                    }

                }

                user.mutedDevice = function () {
                    if (user.sim800) {
                        user.socket.emit('muted', user.sim800.name)
                        user.sim800.off(':readRX', user.onReadRx);
                        user.sim800.off(':writeTX', user.onWriteTx);

                    }
                }

                user.listenDevice();

                socket.on(':remoteWriteTX', function (data) {
                    if (user.sim800) {
                        user.sim800.writeTX(data);
                    }
                });


                socket.on('disconnect', function () {
                    user.mutedDevice();
                    remoteSerialList = remoteSerialList.filter(x => x != user);
                    console.log('client end');
                })
            }
        }
    });


});
