#include <ESP8266WiFi.h>
#include <SocketIoClient.h>


SocketIoClient client;

const char *ssid = "Diem Thuong";
const char *password = "ad2h3ttt";

//const char *ssid = "CTYDANTHANH";
//const char *password = "dtcowifi";


#define LED 2

#define MAX_SIZE_PAYLOAD  1010
#define BUFFER_SIZE  1024

char serialbuffer[BUFFER_SIZE];
int serialbuffer_size;


void alert(int duration, int delayTime, int times, bool blinkFlag = false)
{
  for (int i = 0; i < times; ++i)
  {
    if (i > 0 || blinkFlag) delay(delayTime);
    digitalWrite(LED, LOW);
    delay(duration);
    digitalWrite(LED, HIGH);
  }
}


void serialLoop()
{
  if (!Serial.available()) return;
   digitalWrite(LED, LOW);
  serialbuffer_size = 0;
  serialbuffer[serialbuffer_size++] = '\"';
  bool needSend = false;
  unsigned long crtime = millis();
  unsigned long latime = crtime;
  char c;
  while (crtime - latime < 10)
  {
    crtime = millis();
    if (Serial.available()) {
      c = Serial.read();
      needSend = true;
      if (c == '\n') {
        serialbuffer[serialbuffer_size++] = '\\';
        c = 'n';
      }
      else if (c == '\r') {
        serialbuffer[serialbuffer_size++] = '\\';
        c = 'r';
      }
      else if (c == '\t') {
        serialbuffer[serialbuffer_size++] = '\\';
        c = 't';
      }
      else if (c == '\"' || c == '\'' || c == '\\') {
        serialbuffer[serialbuffer_size++] = '\\';
      }
      serialbuffer[serialbuffer_size++] = c;
      latime = crtime;
    }
    else
      delay(3);
    if (serialbuffer_size >= MAX_SIZE_PAYLOAD)
      break;
  }
  serialbuffer[serialbuffer_size++] = '\"';
  serialbuffer[serialbuffer_size] = 0;
  if (needSend > 0) {
    client.emit(":serial", serialbuffer);
  }
  digitalWrite(LED, HIGH);
}




bool isNumber(char x)
{
  return x >= '0' && x <= '9';
}


void readInt(const char * st, int & x)
{
  bool neg;
  x = 0;
  int i = 0;
  neg = false;
  while (st[i] != 0 && !isNumber(st[i]) && st[i] != '-') ++i;
  if (st[i] == '-')
  {
    neg = true;
    ++i;
  }
  while (isNumber(st[i]))
  {
    x = x * 10;
    x += st[i] - '0';
    ++i;
  }
  if (neg) x = -x;
}


void readInt(const char * st, int & x, int & y)
{
  bool neg;
  x = 0;
  int i = 0;
  neg = false;
  while (st[i] != 0 && !isNumber(st[i]) && st[i] != '-') ++i;
  if (st[i] == '-')
  {
    neg = true;
    ++i;
  }
  while (isNumber(st[i]))
  {
    x = x * 10;
    x += st[i] - '0';
    ++i;
  }
  if (neg) x = -x;

  y = 0;
  neg = false;
  while (st[i] != 0 && !isNumber(st[i]) && st[i] != '-') ++i;
  if (st[i] == '-')
  {
    neg = true;
    ++i;
  }
  while (isNumber(st[i]))
  {
    y = y * 10;
    y += st[i] - '0';
    ++i;
  }
  if (neg) y = -y;


}

void readInt(const char * st, int & x, int & y, int &z)
{
  bool neg;
  x = 0;
  int i = 0;
  neg = false;
  while (st[i] != 0 && !isNumber(st[i]) && st[i] != '-') ++i;
  if (st[i] == '-')
  {
    neg = true;
    ++i;
  }
  while (isNumber(st[i]))
  {
    x = x * 10;
    x += st[i] - '0';
    ++i;
  }
  if (neg) x = -x;

  y = 0;
  neg = false;
  while (st[i] != 0 && !isNumber(st[i]) && st[i] != '-') ++i;
  if (st[i] == '-')
  {
    neg = true;
    ++i;
  }
  while (isNumber(st[i]))
  {
    y = y * 10;
    y += st[i] - '0';
    ++i;
  }
  if (neg) y = -y;

  z = 0;
  neg = false;
  while (st[i] != 0 && !isNumber(st[i]) && st[i] != '-') ++i;
  if (st[i] == '-')
  {
    neg = true;
    ++i;
  }
  while (isNumber(st[i]))
  {
    z = z * 10;
    z += st[i] - '0';
    ++i;
  }
  if (neg) z = -z;
}

void whoEvent(const char * payload, size_t length){
   client.emit("iam", "\"Gardevoir 001\"");
}

void serialWriteEvent(const char * payload, size_t length)
{
  //  Serial.print(payload);
  //  return;
  char c;
  for (int i = 0; i < length && payload[i] != 0; ++i)
  {
    c = payload[i];
    if (c == '\\')
    {
      c = payload[++i];
      if (c == 'n') c = '\n';
      else if (c == 't') c = '\t';
      else if (c == 'r') c = '\r';
    }

    Serial.print(c);
  }
}


void setup()
{
  pinMode(LED, OUTPUT);
  WiFi.mode(WIFI_STA);
  //Kết nối vào mạng Wifi
  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED)
  {
    alert(100, 100, 1, true);
  }
  delay(500);

  Serial.begin(115200);
  delay(10);

  client.on(":serialwrite", serialWriteEvent);
  client.on("who", whoEvent);
  
  client.begin("volcanion.cf", 107);
}

void loop()
{

  serialLoop();
  client.loop();
}
