const EventEmittor = require('eventemitter3');
const SERIAL_RX = ':serial';
const SERIAL_TX = ':serialwrite';
const READ_RX = ':readRX';
const WRITE_TX = ':writeTX';

class Sim800L extends EventEmittor {
    constructor(props) {
        super();
        Object.assign(this, props || {});
        this.sync = Promise.resolve();
        this.lineLeft = "";
    }
    /**
     * 
     * @param {SocketIO} socket 
     */
    attach(socket) {
        this.socket = socket;
        this.socket.on(SERIAL_RX, this.handlerRXData.bind(this));
        this.emit('attach', { socket: socket, target: this });
        this.socket.on('disconnect', this.detach.bind(this));
    }

    detach() {
        this.socket = null;
        this.emit('dettach', { target: this });
    }

    handlerRXData(data) {
        this.emit(READ_RX, data);
        if (data.trim().toLowerCase() == 'ring') {
            this.emit('ring');
        }
    }

    askAccoutInfo() {
        this.sync = this.sync.then(u => {
            this.writeTX("AT+CUSD=1,\"*101#\"\r\n");
            return new Promise((rs, rj) => {
                var state = 0;
                var dataHandler = (text) => {
                    if (state == 0) {
                        var statusMatched = text.match('');
                    }
                }
                this.on(READ_RX, dataHandler);
            });
        });
    }
    /**
     * 
     * @param {String} phoneNumber 
     */
    call(phoneNumber) {

    };

    writeTX(data) {
        this.socket.emit(SERIAL_TX, data);
        this.emit(WRITE_TX, data);
    }


};

module.exports = Sim800L;
